<?php


if (!defined('ABSPATH')) {
    exit;
}


function is_cloudflare_turnstile_enabled()
{
    return get_option('upgram_cloudflare_site_key') && get_option('upgram_cloudflare_secret_key');
}

function verify_cloudflare_turnstile($token)
{
    $secret_key =  get_option('upgram_cloudflare_secret_key');
    if (empty($secret_key)) return false;
    $verify_url = 'https://challenges.cloudflare.com/turnstile/v0/siteverify';
    $response = wp_remote_post($verify_url, [
        'body' => ['secret' => $secret_key, 'response' => $token]
    ]);
    if (is_wp_error($response)) return false;
    $response_body = json_decode(wp_remote_retrieve_body($response));
    if (isset($response_body->success) && $response_body->success) {
        return true;
    }
    return false;
}
